/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.bases.McdwAxe;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.registries.EnchantsRegistry;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import org.jetbrains.annotations.NotNull;

public enum AxesID implements IMeleeWeaponID,
IInnateEnchantment
{
    AXE_ANCHOR((class_1832)class_1834.field_8923, 8, -3.4f, "minecraft:iron_ingot"),
    AXE_AXE((class_1832)class_1834.field_8923, 6, -3.1f, "minecraft:iron_ingot"),
    AXE_ENCRUSTED_ANCHOR((class_1832)class_1834.field_8930, 8, -3.4f, "minecraft:diamond"),
    AXE_FIREBRAND((class_1832)class_1834.field_8930, 4, -2.9f, "minecraft:diamond"),
    AXE_HIGHLAND((class_1832)class_1834.field_8923, 4, -2.9f, "minecraft:iron_ingot");

    private final class_1832 material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private AxesID(class_1832 material, int damage, float attackSpeed, String ... repairIngredient) {
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static HashMap<AxesID, Boolean> getEnabledItems() {
        return Mcdw.CONFIG.mcdwEnableItemsConfig.AXES_ENABLED;
    }

    public static EnumMap<AxesID, McdwAxe> getItemsEnum() {
        return ItemsRegistry.AXE_ITEMS;
    }

    public static HashMap<AxesID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.AXE_SPAWN_RATES;
    }

    public static HashMap<AxesID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.axeStats;
    }

    @Override
    public Boolean isEnabled() {
        return AxesID.getEnabledItems().get(this);
    }

    public McdwAxe getItem() {
        return AxesID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return AxesID.getSpawnRates().get(this);
    }

    public HashMap<AxesID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.axeStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return AxesID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.axeStats.get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public Map<class_1887, Integer> getInnateEnchantments() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case AXE_ANCHOR -> Map.of(EnchantsRegistry.GRAVITY, 1);
            case AXE_AXE -> null;
            case AXE_ENCRUSTED_ANCHOR -> Map.of(EnchantsRegistry.GRAVITY, 1, EnchantsRegistry.JUNGLE_POISON, 1);
            case AXE_FIREBRAND -> Map.of(class_1893.field_9124, 1);
            case AXE_HIGHLAND -> Map.of(EnchantsRegistry.STUNNING, 1);
        };
    }

    @Override
    @NotNull
    public class_1799 getInnateEnchantedStack(class_1792 item) {
        return item.method_7854();
    }

    public McdwAxe makeWeapon() {
        McdwAxe mcdwAxe = new McdwAxe(this, ItemsRegistry.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        AxesID.getItemsEnum().put(this, mcdwAxe);
        return mcdwAxe;
    }
}

