/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.bases.McdwSickle;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.registries.EnchantsRegistry;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1887;
import org.jetbrains.annotations.NotNull;

public enum SicklesID implements IMeleeWeaponID,
IInnateEnchantment
{
    SICKLE_LAST_LAUGH_GOLD((class_1832)class_1834.field_8923, 2, -2.1f, "minecraft:iron_ingot"),
    SICKLE_LAST_LAUGH_SILVER((class_1832)class_1834.field_8923, 2, -2.1f, "minecraft:iron_ingot"),
    SICKLE_NIGHTMARES_BITE((class_1832)class_1834.field_8923, 2, -2.1f, "minecraft:iron_ingot"),
    SICKLE_SICKLE((class_1832)class_1834.field_8923, 1, -2.1f, "minecraft:iron_ingot");

    private final class_1832 material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private SicklesID(class_1832 material, int damage, float attackSpeed, String ... repairIngredient) {
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static HashMap<SicklesID, Boolean> getEnabledItems() {
        return Mcdw.CONFIG.mcdwEnableItemsConfig.SICKLES_ENABLED;
    }

    public static EnumMap<SicklesID, McdwSickle> getItemsEnum() {
        return ItemsRegistry.SICKLE_ITEMS;
    }

    public static HashMap<SicklesID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.SICKLE_SPAWN_RATES;
    }

    public static HashMap<SicklesID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.sickleStats;
    }

    @Override
    public Boolean isEnabled() {
        return SicklesID.getEnabledItems().get(this);
    }

    public McdwSickle getItem() {
        return SicklesID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return SicklesID.getSpawnRates().get(this);
    }

    public HashMap<SicklesID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.sickleStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return SicklesID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.sickleStats.get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public Map<class_1887, Integer> getInnateEnchantments() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case SICKLE_LAST_LAUGH_GOLD, SICKLE_LAST_LAUGH_SILVER -> Map.of(EnchantsRegistry.PROSPECTOR, 1);
            case SICKLE_NIGHTMARES_BITE -> Map.of(EnchantsRegistry.POISON_CLOUD, 1);
            case SICKLE_SICKLE -> null;
        };
    }

    @Override
    @NotNull
    public class_1799 getInnateEnchantedStack(class_1792 item) {
        return item.method_7854();
    }

    public McdwSickle makeWeapon() {
        McdwSickle mcdwSickle = new McdwSickle(this, ItemsRegistry.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        SicklesID.getItemsEnum().put(this, mcdwSickle);
        return mcdwSickle;
    }
}

