/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.corporea.CorporeaNode;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.ManaSparkEntity;
import vazkii.botania.common.entity.SparkBaseEntity;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.impl.corporea.DummyCorporeaNode;
import vazkii.botania.common.integration.corporea.CorporeaNodeDetectors;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.lib.BotaniaTags;

public class CorporeaSparkEntity
extends SparkBaseEntity
implements CorporeaSpark {
    private static final int SCAN_RANGE = 8;
    private static final String TAG_MASTER = "master";
    private static final String TAG_CREATIVE = "creative";
    private static final class_2940<Boolean> MASTER = class_2945.method_12791(CorporeaSparkEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> CREATIVE = class_2945.method_12791(CorporeaSparkEntity.class, (class_2941)class_2943.field_13323);
    private CorporeaSpark master;
    private Set<CorporeaSpark> connections = new LinkedHashSet<CorporeaSpark>();
    private List<CorporeaSpark> relatives = new ArrayList<CorporeaSpark>();
    private boolean firstTick = true;

    public CorporeaSparkEntity(class_1299<CorporeaSparkEntity> type, class_1937 world) {
        super(type, world);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(MASTER, (Object)false);
        this.field_6011.method_12784(CREATIVE, (Object)false);
    }

    @NotNull
    public class_1799 method_31480() {
        return new class_1799((class_1935)this.getSparkItem());
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) {
            return;
        }
        CorporeaNode node = this.getSparkNode();
        if (node instanceof DummyCorporeaNode && !this.method_37908().method_8320(this.getAttachPos()).method_26164(BotaniaTags.Blocks.CORPOREA_SPARK_OVERRIDE)) {
            this.dropAndKill();
            return;
        }
        if (this.isMaster()) {
            this.master = this;
        }
        if (this.firstTick) {
            if (this.isMaster()) {
                this.restartNetwork();
            } else {
                this.findNetwork();
            }
            this.firstTick = false;
        }
        if (!(this.master == null || this.master.entity().method_5805() && this.master.getNetwork() == this.getNetwork())) {
            this.master = null;
        }
    }

    private void dropAndKill() {
        this.method_5699(new class_1799((class_1935)this.getSparkItem()), 0.0f);
        this.method_31472();
    }

    protected class_1792 getSparkItem() {
        return this.isCreative() ? BotaniaItems.corporeaSparkCreative : (this.isMaster() ? BotaniaItems.corporeaSparkMaster : BotaniaItems.corporeaSpark);
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        this.connections.remove(this);
        this.restartNetwork();
    }

    @Override
    public void introduceNearbyTo(Set<CorporeaSpark> network, CorporeaSpark master) {
        this.relatives.clear();
        for (CorporeaSpark spark : this.getNearbySparks()) {
            if (spark == null || network.contains(spark) || spark.getNetwork() != this.getNetwork() || spark.isMaster() || !spark.entity().method_5805()) continue;
            network.add(spark);
            this.relatives.add(spark);
            spark.introduceNearbyTo(network, master);
        }
        this.master = master;
        this.connections = network;
    }

    private List<CorporeaSpark> getNearbySparks() {
        return this.method_37908().method_8390(class_1297.class, new class_238(this.method_23317() - 8.0, this.method_23318() - 8.0, this.method_23321() - 8.0, this.method_23317() + 8.0, this.method_23318() + 8.0, this.method_23321() + 8.0), (Predicate)Predicates.instanceOf(CorporeaSpark.class));
    }

    private void restartNetwork() {
        this.connections = new LinkedHashSet<CorporeaSpark>();
        this.relatives = new ArrayList<CorporeaSpark>();
        if (this.master != null) {
            CorporeaSpark oldMaster = this.master;
            this.master = null;
            oldMaster.introduceNearbyTo(new LinkedHashSet<CorporeaSpark>(), oldMaster);
        }
    }

    private void findNetwork() {
        for (CorporeaSpark spark : this.getNearbySparks()) {
            CorporeaSpark master;
            if (spark.getNetwork() != this.getNetwork() || !spark.entity().method_5805() || (master = spark.getMaster()) == null) continue;
            this.master = master;
            this.restartNetwork();
            break;
        }
    }

    private static void displayRelatives(class_1657 player, List<CorporeaSpark> checked, CorporeaSpark spark) {
        if (spark == null) {
            return;
        }
        List<CorporeaSpark> sparks = spark.getRelatives();
        if (sparks.isEmpty()) {
            ManaSparkEntity.particleBeam(player, spark.entity(), spark.getMaster().entity());
        } else {
            for (CorporeaSpark endSpark : sparks) {
                if (checked.contains(endSpark)) continue;
                ManaSparkEntity.particleBeam(player, spark.entity(), endSpark.entity());
                checked.add(endSpark);
                CorporeaSparkEntity.displayRelatives(player, checked, endSpark);
            }
        }
    }

    @Override
    public CorporeaNode getSparkNode() {
        return CorporeaNodeDetectors.findNode(this.method_37908(), this);
    }

    @Override
    public Set<CorporeaSpark> getConnections() {
        return this.connections;
    }

    @Override
    public List<CorporeaSpark> getRelatives() {
        return this.relatives;
    }

    @Override
    public void onItemExtracted(class_1799 stack) {
        ((class_3218)this.method_37908()).method_14199((class_2394)new class_2392(class_2398.field_11218, stack), this.method_23317(), this.method_23318(), this.method_23321(), 10, 0.125, 0.125, 0.125, 0.05);
    }

    @Override
    public void onItemsRequested(List<class_1799> stacks) {
        ArrayList<class_1792> shownItems = new ArrayList<class_1792>();
        for (class_1799 stack : stacks) {
            if (shownItems.contains(stack.method_7909())) continue;
            shownItems.add(stack.method_7909());
            ((class_3218)this.method_37908()).method_14199((class_2394)new class_2392(class_2398.field_11218, stack), this.method_23317(), this.method_23318(), this.method_23321(), 10, 0.125, 0.125, 0.125, 0.05);
        }
    }

    @Override
    public CorporeaSpark getMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.field_6011.method_12778(MASTER, (Object)master);
    }

    @Override
    public boolean isMaster() {
        return (Boolean)this.field_6011.method_12789(MASTER);
    }

    public void setCreative(boolean creative) {
        this.field_6011.method_12778(CREATIVE, (Object)creative);
    }

    @Override
    public boolean isCreative() {
        return (Boolean)this.field_6011.method_12789(CREATIVE);
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (this.method_5805() && !stack.method_7960()) {
            if (stack.method_7909() instanceof WandOfTheForestItem) {
                if (!this.method_37908().field_9236) {
                    if (player.method_5715()) {
                        this.dropAndKill();
                        if (this.isMaster()) {
                            this.restartNetwork();
                        }
                    } else {
                        CorporeaSparkEntity.displayRelatives(player, new ArrayList<CorporeaSpark>(), this.master);
                    }
                }
                return class_1269.method_29236((boolean)this.method_37908().field_9236);
            }
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1769) {
                class_1769 dye = (class_1769)class_17922;
                class_1767 color = dye.method_7802();
                if (color != this.getNetwork()) {
                    if (!this.method_37908().field_9236) {
                        this.setNetwork(color);
                        stack.method_7934(1);
                    }
                    return class_1269.method_29236((boolean)this.method_37908().field_9236);
                }
            } else if (stack.method_31574(BotaniaItems.phantomInk)) {
                if (!this.method_37908().field_9236) {
                    this.method_5648(true);
                }
                return class_1269.method_29236((boolean)this.method_37908().field_9236);
            }
        }
        return class_1269.field_5811;
    }

    @Override
    public void setNetwork(class_1767 color) {
        if (color == this.getNetwork()) {
            return;
        }
        super.setNetwork(color);
        if (!this.firstTick) {
            if (this.isMaster()) {
                this.restartNetwork();
            } else {
                this.findNetwork();
            }
        }
    }

    @Override
    protected void method_5749(@NotNull class_2487 cmp) {
        super.method_5749(cmp);
        this.setMaster(cmp.method_10577(TAG_MASTER));
        this.setCreative(cmp.method_10577(TAG_CREATIVE));
    }

    @Override
    protected void method_5652(@NotNull class_2487 cmp) {
        super.method_5652(cmp);
        cmp.method_10556(TAG_MASTER, this.isMaster());
        cmp.method_10556(TAG_CREATIVE, this.isCreative());
    }

    public record WandHud(CorporeaSparkEntity entity) implements WandHUD
    {
        @Override
        public void renderHUD(class_332 gui, class_310 mc) {
            class_1799 sparkStack = new class_1799((class_1935)this.entity.getSparkItem());
            class_1767 networkColor = this.entity.getNetwork();
            class_5250 networkColorName = class_2561.method_43471((String)("color.minecraft." + networkColor.method_7792())).method_27692(class_124.field_1056);
            int textColor = ColorHelper.getColorLegibleOnGrayBackground(networkColor);
            int width = 4 + Math.max(mc.field_1772.method_27525((class_5348)networkColorName), RenderHelper.itemWithNameWidth(mc, sparkStack));
            int networkColorTextStart = mc.field_1772.method_27525((class_5348)networkColorName) / 2;
            int centerX = mc.method_22683().method_4486() / 2;
            int centerY = mc.method_22683().method_4502() / 2;
            RenderHelper.renderHUDBox(gui, centerX - width / 2, centerY + 8, centerX + width / 2, centerY + 38);
            RenderHelper.renderItemWithNameCentered(gui, mc, sparkStack, centerY + 10, textColor);
            gui.method_27535(mc.field_1772, (class_2561)networkColorName, centerX - networkColorTextStart, centerY + 28, textColor);
        }
    }
}

