/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.parties;

import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.client.parties.party.ClientParty;
import xaero.pac.client.parties.party.IClientPartyStorage;
import xaero.pac.common.packet.parties.PartyPlayerInfoCodec;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.PartyMember;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundPartyPacket
extends LazyPacket<ClientboundPartyPacket> {
    public static final Codec CODEC = new Codec(new PartyPlayerInfoCodec());
    private final UUID partyId;
    private final IPartyMember owner;
    private final int memberCount;
    private final int inviteCount;
    private final int allyCount;
    private final int memberLimit;
    private final int inviteLimit;
    private final int allyLimit;

    public ClientboundPartyPacket(UUID partyId, IPartyMember owner, int memberCount, int inviteCount, int allyCount, int memberLimit, int inviteLimit, int allyLimit) {
        this.partyId = partyId;
        this.owner = owner;
        this.memberCount = memberCount;
        this.inviteCount = inviteCount;
        this.allyCount = allyCount;
        this.memberLimit = memberLimit;
        this.inviteLimit = inviteLimit;
        this.allyLimit = allyLimit;
    }

    @Override
    protected Function<class_2540, ClientboundPartyPacket> getDecoder() {
        return CODEC;
    }

    @Override
    protected void writeOnPrepare(class_2540 u) {
        class_2487 partyTag = new class_2487();
        if (this.partyId == null) {
            u.method_10794(partyTag);
            return;
        }
        partyTag.method_25927("i", this.partyId);
        class_2487 ownerTag = ClientboundPartyPacket.CODEC.playerInfoCodec.toMemberTag((PartyMember)this.owner);
        partyTag.method_10566("o", (class_2520)ownerTag);
        partyTag.method_10569("mc", this.memberCount);
        partyTag.method_10569("ic", this.inviteCount);
        partyTag.method_10569("ac", this.allyCount);
        partyTag.method_10569("ml", this.memberLimit);
        partyTag.method_10569("il", this.inviteLimit);
        partyTag.method_10569("al", this.allyLimit);
        u.method_10794(partyTag);
    }

    protected static class Codec
    extends LazyPacket.Encoder<ClientboundPartyPacket>
    implements Function<class_2540, ClientboundPartyPacket> {
        private final PartyPlayerInfoCodec playerInfoCodec;

        public Codec(PartyPlayerInfoCodec playerInfoCodec) {
            this.playerInfoCodec = playerInfoCodec;
        }

        @Override
        public ClientboundPartyPacket apply(class_2540 input) {
            try {
                if (input.readableBytes() > 102400) {
                    return null;
                }
                class_2487 partyTag = input.method_30617();
                if (partyTag == null) {
                    return null;
                }
                if (partyTag.method_33133()) {
                    return new ClientboundPartyPacket(null, null, 0, 0, 0, 0, 0, 0);
                }
                UUID partyId = partyTag.method_25926("i");
                class_2487 ownerTag = partyTag.method_10562("o");
                if (ownerTag.method_33133()) {
                    OpenPartiesAndClaims.LOGGER.info("Received party packet with no owner info.");
                    return null;
                }
                PartyMember owner = this.playerInfoCodec.fromMemberTag(ownerTag, true);
                if (owner == null) {
                    OpenPartiesAndClaims.LOGGER.info("Received party packet with invalid owner info data.");
                    return null;
                }
                int memberCount = partyTag.method_10550("mc");
                int inviteCount = partyTag.method_10550("ic");
                int allyCount = partyTag.method_10550("ac");
                int memberLimit = partyTag.method_10550("ml");
                int inviteLimit = partyTag.method_10550("il");
                int allyLimit = partyTag.method_10550("al");
                return new ClientboundPartyPacket(partyId, owner, memberCount, inviteCount, allyCount, memberLimit, inviteLimit, allyLimit);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet ", t);
                return null;
            }
        }
    }

    public static class ClientHandler
    extends LazyPacket.Handler<ClientboundPartyPacket> {
        @Override
        public void handle(ClientboundPartyPacket t) {
            ClientParty party = t.partyId == null ? null : ClientParty.Builder.begin().setId(t.partyId).setOwner((PartyMember)t.owner).build();
            ((IClientPartyStorage)OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage()).setPartyCast(party);
            ((IClientPartyStorage)OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage()).setLoadingMemberCount(t.memberCount);
            ((IClientPartyStorage)OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage()).setLoadingInviteCount(t.inviteCount);
            ((IClientPartyStorage)OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage()).setLoadingAllyCount(t.allyCount);
            ((IClientPartyStorage)OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage()).setMemberLimit(t.memberLimit);
            ((IClientPartyStorage)OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage()).setInviteLimit(t.inviteLimit);
            ((IClientPartyStorage)OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage()).setAllyLimit(t.allyLimit);
        }
    }
}

