/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.sync.player;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.ServerClaimsManager;
import xaero.pac.common.server.claims.ServerDimensionClaimsManager;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.claims.sync.ClaimsManagerSynchronizer;
import xaero.pac.common.server.claims.sync.player.ClaimsManagerPlayerDimensionRegionSync;
import xaero.pac.common.server.claims.sync.player.ClaimsManagerPlayerLazyPacketScheduler;
import xaero.pac.common.server.claims.sync.player.ClaimsManagerPlayerStateSync;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.parties.party.IServerParty;

public final class ClaimsManagerPlayerRegionSync
extends ClaimsManagerPlayerLazyPacketScheduler {
    private final List<ClaimsManagerPlayerDimensionRegionSync> dimsToSync;
    private ClaimsManagerPlayerDimensionRegionSync currentPrefix;
    private final ClaimsManagerPlayerStateSync stateSyncHandler;
    private boolean calledOnce;

    private ClaimsManagerPlayerRegionSync(ClaimsManagerSynchronizer synchronizer, List<ClaimsManagerPlayerDimensionRegionSync> dimsToSync, ClaimsManagerPlayerStateSync stateSyncHandler) {
        super(synchronizer);
        this.dimsToSync = dimsToSync;
        this.stateSyncHandler = stateSyncHandler;
    }

    private void sendDimensionPrefix(class_3222 player, ClaimsManagerPlayerDimensionRegionSync dim) {
        if (dim != this.currentPrefix) {
            class_2960 dimLocation = dim == null ? null : dim.getDim();
            this.synchronizer.syncDimensionIdToClient(dimLocation, player);
            this.currentPrefix = dim;
        }
    }

    @Override
    public void onTick(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, class_3222 player, int limit) {
        boolean done;
        this.calledOnce = true;
        int count = 0;
        while (!this.dimsToSync.isEmpty()) {
            ClaimsManagerPlayerDimensionRegionSync dim = this.dimsToSync.get(0);
            this.sendDimensionPrefix(player, dim);
            count += dim.handle(serverData, player, this.synchronizer, limit - count);
            if (count >= limit) break;
            this.dimsToSync.remove(0);
        }
        if (done = this.dimsToSync.isEmpty()) {
            this.sendDimensionPrefix(player, null);
            this.synchronizer.endSyncing(player);
        }
    }

    @Override
    public void start(class_3222 player) {
        super.start(player);
        if (this.dimsToSync.isEmpty()) {
            this.sendDimensionPrefix(player, null);
            this.synchronizer.endSyncing(player);
        }
    }

    @Override
    public void onLazyPacketsDropped() {
        this.dimsToSync.clear();
    }

    @Override
    public boolean shouldWorkNotClogged(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, class_3222 player) {
        return this.started && this.stateSyncHandler.isFinished() && (!this.calledOnce || !this.dimsToSync.isEmpty());
    }

    public static final class Builder {
        private IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>> claimsManager;
        private ClaimsManagerPlayerStateSync stateSyncHandler;
        private UUID playerId;

        private Builder() {
        }

        private Builder setDefault() {
            this.setClaimsManager(null);
            this.setPlayerId(null);
            return this;
        }

        public Builder setClaimsManager(IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>> claimsManager) {
            this.claimsManager = claimsManager;
            return this;
        }

        public Builder setStateSyncHandler(ClaimsManagerPlayerStateSync stateSyncHandler) {
            this.stateSyncHandler = stateSyncHandler;
            return this;
        }

        public Builder setPlayerId(UUID playerId) {
            this.playerId = playerId;
            return this;
        }

        public ClaimsManagerPlayerRegionSync build() {
            if (this.claimsManager == null || this.stateSyncHandler == null || this.playerId == null) {
                throw new IllegalStateException();
            }
            ArrayList<ClaimsManagerPlayerDimensionRegionSync> dimsToSync = new ArrayList<ClaimsManagerPlayerDimensionRegionSync>();
            if (ServerConfig.CONFIG.claimsSynchronization.get() != ServerConfig.ClaimsSyncType.NOT_SYNCED) {
                boolean ownedOnly = ServerConfig.CONFIG.claimsSynchronization.get() == ServerConfig.ClaimsSyncType.OWNED_ONLY;
                boolean allowExistingUnclaimableClaims = (Boolean)ServerConfig.CONFIG.allowExistingClaimsInUnclaimableDimensions.get();
                ((ServerClaimsManager)this.claimsManager).getDimensionStream().forEach(dim -> {
                    boolean serverOnly = !allowExistingUnclaimableClaims && !this.claimsManager.isClaimable(dim.getDimension());
                    dimsToSync.add(new ClaimsManagerPlayerDimensionRegionSync((ServerDimensionClaimsManager)dim, ownedOnly, serverOnly));
                });
            }
            ClaimsManagerPlayerRegionSync result = new ClaimsManagerPlayerRegionSync((ClaimsManagerSynchronizer)this.claimsManager.getClaimsManagerSynchronizer(), dimsToSync, this.stateSyncHandler);
            return result;
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

