/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.expiration;

import java.util.Iterator;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.expiration.ObjectManagerIOExpirableObject;
import xaero.pac.common.server.expiration.ObjectManagerIOExpirableObjectManager;
import xaero.pac.common.server.expiration.task.ObjectExpirationCheckSpreadoutTask;
import xaero.pac.common.server.info.ServerInfo;
import xaero.pac.common.server.io.ObjectManagerIOManager;
import xaero.pac.common.server.parties.party.IServerParty;

public abstract class ObjectExpirationHandler<T extends ObjectManagerIOExpirableObject, M extends ObjectManagerIOManager<T, M> & ObjectManagerIOExpirableObjectManager<T>> {
    private final ServerInfo serverInfo;
    protected final M manager;
    private final long liveCheckInterval;
    private long lastCheck;
    private Iterator<T> checkingIterator;
    private final String checkingMessage;
    private final long expirationTime;
    private boolean expiringAnElement;

    protected ObjectExpirationHandler(ServerInfo serverInfo, M manager, long liveCheckInterval, long expirationTime, String checkingMessage) {
        this.serverInfo = serverInfo;
        this.manager = manager;
        this.liveCheckInterval = liveCheckInterval;
        this.expirationTime = expirationTime;
        this.checkingMessage = checkingMessage;
        this.lastCheck = serverInfo.getUseTime();
    }

    public abstract void preExpirationCheck(T var1);

    public abstract boolean checkIfActive(T var1);

    public abstract boolean expire(T var1, IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> var2);

    protected void handle(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData) {
        this.checkingIterator = ((ObjectManagerIOExpirableObjectManager)this.manager).getExpirationIterator();
        this.lastCheck = this.serverInfo.getUseTime();
        OpenPartiesAndClaims.LOGGER.debug(this.checkingMessage);
        serverData.getObjectExpirationCheckTaskHandler().addTask(new ObjectExpirationCheckSpreadoutTask<T>(this, this.checkingIterator), serverData);
    }

    public void onElementExpirationBegin() {
        this.expiringAnElement = true;
    }

    public void onElementExpirationDone() {
        this.expiringAnElement = false;
    }

    public boolean isExpiringAnElement() {
        return this.expiringAnElement;
    }

    public void onIterationDone() {
        OpenPartiesAndClaims.LOGGER.debug("Expiration iteration has finished!");
        this.checkingIterator = null;
    }

    public boolean onServerTick(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData) {
        if (this.checkingIterator != null) {
            return true;
        }
        if (this.serverInfo.getUseTime() - this.lastCheck > this.liveCheckInterval) {
            this.handle(serverData);
            return true;
        }
        return false;
    }

    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public static abstract class Builder<T extends ObjectManagerIOExpirableObject, M extends ObjectManagerIOManager<T, M> & ObjectManagerIOExpirableObjectManager<T>, B extends Builder<T, M, B>> {
        protected final B self = this;
        protected ServerInfo serverInfo;
        protected M manager;
        protected long liveCheckInterval;
        protected String checkingMessage;
        protected long expirationTime;

        protected Builder() {
        }

        public B setDefault() {
            this.setServerInfo(null);
            this.setManager(null);
            this.setLiveCheckInterval(0L);
            this.setCheckingMessage(null);
            this.setExpirationTime(0L);
            return this.self;
        }

        public B setServerInfo(ServerInfo serverInfo) {
            this.serverInfo = serverInfo;
            return this.self;
        }

        public B setManager(M manager) {
            this.manager = manager;
            return this.self;
        }

        public B setLiveCheckInterval(long liveCheckInterval) {
            this.liveCheckInterval = liveCheckInterval;
            return this.self;
        }

        public B setCheckingMessage(String checkingMessage) {
            this.checkingMessage = checkingMessage;
            return this.self;
        }

        public B setExpirationTime(long expirationTime) {
            this.expirationTime = expirationTime;
            return this.self;
        }

        public ObjectExpirationHandler<T, M> build() {
            if (this.serverInfo == null || this.manager == null || this.liveCheckInterval <= 0L || this.checkingMessage == null || this.expirationTime <= 0L) {
                throw new IllegalStateException();
            }
            return this.buildInternally();
        }

        protected abstract ObjectExpirationHandler<T, M> buildInternally();
    }
}

