/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.party.sync;

import java.util.Iterator;
import java.util.function.Predicate;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.Party;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.PartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.lazypacket.LazyPacket;
import xaero.pac.common.server.parties.party.IServerParty;

public abstract class AbstractPartySynchronizer {
    protected final MinecraftServer server;
    protected IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData;

    public AbstractPartySynchronizer(MinecraftServer server) {
        this.server = server;
    }

    public void setServerData(IServerData<?, ?> serverData) {
        if (this.serverData != null) {
            throw new IllegalAccessError();
        }
        this.serverData = serverData;
    }

    protected void sendToClient(class_3222 player, Object packet, boolean instant) {
        if (instant) {
            OpenPartiesAndClaims.INSTANCE.getPacketHandler().sendToPlayer(player, packet);
        } else {
            this.serverData.getServerTickHandler().getLazyPacketSender().enqueue(player, (LazyPacket)packet);
        }
    }

    protected void instantSendToClient(class_3222 player, Object packet) {
    }

    private void sendToMember(PartyMember mi, Predicate<IPartyPlayerInfo> exception, class_3324 playerList, Object packet, boolean instant) {
        if (exception.test(mi)) {
            return;
        }
        class_3222 onlinePlayer = playerList.method_14602(mi.getUUID());
        if (onlinePlayer != null) {
            this.sendToClient(onlinePlayer, packet, instant);
        }
    }

    protected void syncToParty(Party party, Predicate<IPartyPlayerInfo> exception, Object packet, boolean instant) {
        class_3324 playerList = this.server.method_3760();
        if (playerList.method_14574() > party.getMemberCount()) {
            Iterator iterator = party.getMemberInfoStream().iterator();
            while (iterator.hasNext()) {
                this.sendToMember((PartyMember)iterator.next(), exception, playerList, packet, instant);
            }
        } else {
            for (class_3222 onlinePlayer : playerList.method_14571()) {
                PartyMember memberInfo = party.getMemberInfo(onlinePlayer.method_5667());
                if (memberInfo == null || exception.test(memberInfo)) continue;
                this.sendToClient(onlinePlayer, packet, instant);
            }
        }
    }
}

