/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.permission;

import java.util.Map;
import javax.annotation.Nonnull;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.misc.MapFactory;
import xaero.pac.common.server.player.permission.IPlayerPermissionSystemManager;
import xaero.pac.common.server.player.permission.api.IPlayerPermissionSystemAPI;

public final class PlayerPermissionSystemManager
implements IPlayerPermissionSystemManager {
    private final Map<String, IPlayerPermissionSystemAPI> systems;
    private final Map<IPlayerPermissionSystemAPI, String> systemNames;
    private IPlayerPermissionSystemAPI usedSystem;
    private boolean registeringAddons;

    private PlayerPermissionSystemManager(Map<String, IPlayerPermissionSystemAPI> systems, Map<IPlayerPermissionSystemAPI, String> systemNames) {
        this.systems = systems;
        this.systemNames = systemNames;
    }

    @Override
    public void preRegister() {
        this.registeringAddons = true;
    }

    @Override
    public void register(@Nonnull String name, @Nonnull IPlayerPermissionSystemAPI system) {
        if (!this.registeringAddons) {
            throw new IllegalStateException("You must register OPAC addons during the OPACServerAddonRegister event! (OPACServerAddonRegisterEvent on Forge)");
        }
        if (this.systems.containsKey(name)) {
            throw new IllegalArgumentException("This permission system name is already registered!");
        }
        this.systems.put(name, system);
        this.systemNames.put(system, name);
        OpenPartiesAndClaims.LOGGER.info("Registered permission system for OPAC: {}", (Object)name);
    }

    @Override
    public void postRegister() {
        this.registeringAddons = false;
    }

    @Override
    public void updateUsedSystem(String configuredName) {
        if (configuredName.isEmpty()) {
            this.usedSystem = null;
            return;
        }
        this.usedSystem = this.systems.get(configuredName);
        if (this.usedSystem == null) {
            OpenPartiesAndClaims.LOGGER.warn("The configured permission system \"{}\" isn't registered!", (Object)configuredName);
            if (this.systems.isEmpty()) {
                return;
            }
            this.usedSystem = this.systems.values().stream().findFirst().get();
        }
        OpenPartiesAndClaims.LOGGER.info("Configured OPAC to use the following permission system: {}", (Object)this.systemNames.get(this.usedSystem));
    }

    @Override
    public Iterable<String> getRegisteredNames() {
        return this.systems.keySet();
    }

    @Override
    public IPlayerPermissionSystemAPI getUsedSystem() {
        return this.usedSystem;
    }

    public static final class Builder {
        private final MapFactory mapFactory;

        private Builder(MapFactory mapFactory) {
            this.mapFactory = mapFactory;
        }

        public Builder setDefault() {
            return this;
        }

        public PlayerPermissionSystemManager build() {
            if (this.mapFactory == null) {
                throw new IllegalStateException();
            }
            return new PlayerPermissionSystemManager(this.mapFactory.get(), this.mapFactory.get());
        }

        public static Builder begin(MapFactory mapFactory) {
            return new Builder(mapFactory).setDefault();
        }
    }
}

