/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.shadowed.moandjiezana.toml;

import mod.azure.shadowed.moandjiezana.toml.BooleanValueReaderWriter;
import mod.azure.shadowed.moandjiezana.toml.DateValueReaderWriter;
import mod.azure.shadowed.moandjiezana.toml.MapValueWriter;
import mod.azure.shadowed.moandjiezana.toml.NumberValueReaderWriter;
import mod.azure.shadowed.moandjiezana.toml.ObjectValueWriter;
import mod.azure.shadowed.moandjiezana.toml.PrimitiveArrayValueWriter;
import mod.azure.shadowed.moandjiezana.toml.StringValueReaderWriter;
import mod.azure.shadowed.moandjiezana.toml.TableArrayValueWriter;
import mod.azure.shadowed.moandjiezana.toml.ValueWriter;

class ValueWriters {
    static final ValueWriters WRITERS = new ValueWriters();
    private static final ValueWriter[] VALUE_WRITERS = new ValueWriter[]{StringValueReaderWriter.STRING_VALUE_READER_WRITER, NumberValueReaderWriter.NUMBER_VALUE_READER_WRITER, BooleanValueReaderWriter.BOOLEAN_VALUE_READER_WRITER, ValueWriters.getPlatformSpecificDateConverter(), MapValueWriter.MAP_VALUE_WRITER, PrimitiveArrayValueWriter.PRIMITIVE_ARRAY_VALUE_WRITER, TableArrayValueWriter.TABLE_ARRAY_VALUE_WRITER};

    ValueWriter findWriterFor(Object value) {
        for (ValueWriter valueWriter : VALUE_WRITERS) {
            if (!valueWriter.canWrite(value)) continue;
            return valueWriter;
        }
        return ObjectValueWriter.OBJECT_VALUE_WRITER;
    }

    private ValueWriters() {
    }

    private static DateValueReaderWriter getPlatformSpecificDateConverter() {
        String specificationVersion = Runtime.class.getPackage().getSpecificationVersion();
        return specificationVersion != null && specificationVersion.startsWith("1.6") ? DateValueReaderWriter.DATE_PARSER_JDK_6 : DateValueReaderWriter.DATE_VALUE_READER_WRITER;
    }
}

