/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.herbalbrews.entities;

import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_5558;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import satisfyu.herbalbrews.blocks.TeaKettleBlock;
import satisfyu.herbalbrews.client.gui.handler.TeaKettleGuiHandler;
import satisfyu.herbalbrews.recipe.TeaKettleRecipe;
import satisfyu.herbalbrews.registry.BlockEntityRegistry;
import satisfyu.herbalbrews.registry.RecipeTypeRegistry;
import satisfyu.herbalbrews.registry.TagsRegistry;
import satisfyu.herbalbrews.util.ImplementedInventory;

public class TeaKettleBlockEntity
extends class_2586
implements class_5558<TeaKettleBlockEntity>,
ImplementedInventory,
class_3908 {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)7, (Object)class_1799.field_8037);
    private static final int MAX_CAPACITY = 7;
    public static final int MAX_COOKING_TIME = 600;
    private int cookingTime;
    public static final int OUTPUT_SLOT = 0;
    private static final int INGREDIENTS_AREA = 6;
    private static final int[] INPUT_SLOTS = new int[]{1, 2, 3, 4, 5, 6};
    private boolean isBeingBurned;
    protected float experience;
    private final class_3913 delegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> TeaKettleBlockEntity.this.cookingTime;
                case 1 -> {
                    if (TeaKettleBlockEntity.this.isBeingBurned) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    TeaKettleBlockEntity.this.cookingTime = value;
                    break;
                }
                case 1: {
                    TeaKettleBlockEntity.this.isBeingBurned = value != 0;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public TeaKettleBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)BlockEntityRegistry.TEA_KETTLE_BLOCK_ENTITY.get(), pos, state);
    }

    public void dropExperience(class_3218 world, class_243 pos) {
        class_1303.method_31493((class_3218)world, (class_243)pos, (int)((int)this.experience));
    }

    @Override
    public int[] method_5494(class_2350 side) {
        if (side.equals((Object)class_2350.field_11033)) {
            return INPUT_SLOTS;
        }
        return INPUT_SLOTS;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.cookingTime = nbt.method_10550("CookingTime");
        this.experience = nbt.method_10583("Experience");
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("CookingTime", this.cookingTime);
        nbt.method_10548("Experience", this.experience);
    }

    public boolean isBeingBurned() {
        if (this.method_10997() == null) {
            throw new NullPointerException("Null world invoked");
        }
        class_2680 belowState = this.method_10997().method_8320(this.method_11016().method_10074());
        Optional optionalList = class_7923.field_41175.method_40266(TagsRegistry.ALLOWS_COOKING);
        class_6885.class_6888 entryList = optionalList.orElse(null);
        if (entryList == null) {
            return false;
        }
        return entryList.method_40241((class_6880)belowState.method_26204().method_40142());
    }

    private boolean canCraft(TeaKettleRecipe recipe) {
        if (recipe == null || recipe.getResultItem().method_7960()) {
            return false;
        }
        if (this.method_5438(0).method_7960()) {
            return true;
        }
        class_1799 recipeOutput = recipe.getResultItem();
        class_1799 outputSlotStack = this.method_5438(0);
        int outputSlotCount = outputSlotStack.method_7947();
        if (!class_1799.method_7984((class_1799)outputSlotStack, (class_1799)recipeOutput)) {
            return false;
        }
        if (outputSlotCount < this.method_5444() && outputSlotCount < outputSlotStack.method_7914()) {
            return true;
        }
        return outputSlotCount < recipeOutput.method_7914();
    }

    private void craft(TeaKettleRecipe recipe) {
        if (!this.canCraft(recipe)) {
            return;
        }
        class_2371 ingredients = class_2371.method_10211();
        for (int i = 1; i <= 6; ++i) {
            ingredients.add((Object)this.method_5438(i));
        }
        for (class_1856 ingredient : recipe.method_8117()) {
            boolean ingredientConsumed = false;
            for (int i = 0; i < ingredients.size(); ++i) {
                class_1799 inputStack = (class_1799)ingredients.get(i);
                if (inputStack.method_7960() || !ingredient.method_8093(inputStack)) continue;
                class_1799 remainderStack = this.getRemainderItem(inputStack);
                inputStack.method_7934(1);
                if (inputStack.method_7960()) {
                    this.method_5447(i + 1, remainderStack);
                }
                ingredientConsumed = true;
                ingredients.set(i, (Object)inputStack);
                break;
            }
            if (ingredientConsumed) continue;
            return;
        }
        class_1799 recipeOutput = recipe.assemble();
        class_1799 outputSlotStack = this.method_5438(0);
        if (outputSlotStack.method_7960()) {
            this.method_5447(0, recipeOutput);
        } else if (outputSlotStack.method_31574(recipeOutput.method_7909())) {
            outputSlotStack.method_7933(recipeOutput.method_7947());
        }
    }

    private class_1799 getRemainderItem(class_1799 stack) {
        if (stack.method_7909().method_7857()) {
            return new class_1799((class_1935)stack.method_7909().method_7858());
        }
        return class_1799.field_8037;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, TeaKettleBlockEntity blockEntity) {
        if (world.method_8608()) {
            return;
        }
        this.isBeingBurned = this.isBeingBurned();
        if (!this.isBeingBurned) {
            if (((Boolean)state.method_11654((class_2769)TeaKettleBlock.LIT)).booleanValue()) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)TeaKettleBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
            }
            return;
        }
        TeaKettleRecipe recipe = world.method_8433().method_8132((class_3956)RecipeTypeRegistry.TEA_KETTLE_RECIPE_TYPE.get(), (class_1263)this, world).orElse(null);
        boolean canCraft = this.canCraft(recipe);
        if (canCraft) {
            ++this.cookingTime;
            if (this.cookingTime >= 600) {
                this.cookingTime = 0;
                this.craft(recipe);
            }
        } else if (!this.canCraft(recipe)) {
            this.cookingTime = 0;
        }
        if (canCraft) {
            world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)TeaKettleBlock.COOKING, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)TeaKettleBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        } else if (((Boolean)state.method_11654((class_2769)TeaKettleBlock.COOKING)).booleanValue()) {
            world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)TeaKettleBlock.COOKING, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)TeaKettleBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        } else if ((Boolean)state.method_11654((class_2769)TeaKettleBlock.LIT) != this.isBeingBurned) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)TeaKettleBlock.LIT, (Comparable)Boolean.valueOf(this.isBeingBurned)), 3);
        }
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    @Override
    public boolean method_5443(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new TeaKettleGuiHandler(syncId, inv, (class_1263)this, this.delegate);
    }
}

