/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4081;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.effect.OrbitingEffect;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class FlameSeedEffect
extends OrbitingEffect {
    public class_1309 sourceEntity;
    public int additionalData;

    public FlameSeedEffect(class_4081 statusEffectCategory, int color) {
        super(statusEffectCategory, color);
        this.setParticleType((class_2394)class_2398.field_22247);
    }

    public void setSourcePlayer(class_1309 livingEntity) {
        this.sourceEntity = livingEntity;
    }

    public void setAdditionalData(int data) {
        this.additionalData = data;
    }

    @Override
    public void method_5572(class_1309 livingEntity, int amplifier) {
        int duration = 0;
        if (!livingEntity.method_37908().method_8608()) {
            class_3218 serverWorld = (class_3218)livingEntity.method_37908();
            float abilityDamage = Config.getFloat("emberstormDamage", "UniqueEffects", ConfigDefaultValues.emberstormDamage);
            float volume = 0.3f;
            float pitch = 1.3f;
            int frequency = 20;
            class_3414 soundEvent = class_3417.field_14821;
            class_1293 class_12932 = livingEntity.method_6112((class_1291)EffectRegistry.FLAMESEED.get());
            if (class_12932 instanceof SimplySwordsStatusEffectInstance) {
                SimplySwordsStatusEffectInstance statusEffect = (SimplySwordsStatusEffectInstance)class_12932;
                this.sourceEntity = statusEffect.getSourceEntity();
                this.additionalData = statusEffect.getAdditionalData();
                duration = statusEffect.method_5584();
            }
            if (livingEntity.field_6012 % frequency == 0 && this.additionalData != 0) {
                class_1282 damageSource = livingEntity.method_48923().method_48831();
                livingEntity.field_6008 = 0;
                if (duration < 20 && this.sourceEntity != null) {
                    HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.method_19538(), (class_2394)class_2398.field_11239, 1.0, 8);
                    HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.method_19538(), (class_2394)class_2398.field_17431, 2.0, 6);
                    HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.method_19538(), (class_2394)class_2398.field_11203, 1.0, 10);
                    HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.method_19538(), (class_2394)class_2398.field_11236, 0.5, 2);
                    HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.method_19538(), (class_2394)class_2398.field_22249, 1.0, 10);
                    abilityDamage = Config.getFloat("emberstormDetonationDamage", "UniqueEffects", ConfigDefaultValues.emberstormDetonationDamage);
                    volume = 0.6f;
                    pitch = 1.0f;
                    soundEvent = (class_3414)SoundRegistry.SPELL_FIRE.get();
                    if (livingEntity.method_5739((class_1297)this.sourceEntity) < 30.0f) {
                        int maxHaste = (int)Config.getFloat("emberstormMaxHaste", "UniqueEffects", ConfigDefaultValues.emberstormMaxHaste);
                        HelperMethods.incrementStatusEffect(this.sourceEntity, class_1294.field_5917, 120, 1, maxHaste);
                    }
                    class_238 box = HelperMethods.createBox((class_1297)livingEntity, 3);
                    for (class_1297 entity : serverWorld.method_8333((class_1297)livingEntity, box, class_1301.field_6157)) {
                        class_1309 le;
                        if (!(entity instanceof class_1309) || !HelperMethods.checkFriendlyFire(le = (class_1309)entity, this.sourceEntity)) continue;
                        le.method_5643(damageSource, abilityDamage);
                        if (le.method_6059((class_1291)EffectRegistry.FLAMESEED.get()) || this.additionalData <= 0) continue;
                        --this.additionalData;
                        SimplySwordsStatusEffectInstance flamSeedEffect = new SimplySwordsStatusEffectInstance((class_1291)EffectRegistry.FLAMESEED.get(), 101, 0, false, false, true);
                        flamSeedEffect.setSourceEntity(this.sourceEntity);
                        flamSeedEffect.setAdditionalData(this.additionalData);
                        le.method_6092((class_1293)flamSeedEffect);
                        le.method_18800(le.method_23317() - livingEntity.method_23317(), 0.5, le.method_23321() - livingEntity.method_23321());
                    }
                }
                if (this.sourceEntity != null) {
                    damageSource = livingEntity.method_48923().method_48815((class_1297)livingEntity, (class_1297)this.sourceEntity);
                    float spellScalingModifier = Config.getFloat("emberstormSpellScaling", "UniqueEffects", ConfigDefaultValues.emberstormSpellScaling);
                    if (HelperMethods.commonSpellAttributeScaling(spellScalingModifier, (class_1297)this.sourceEntity, "fire") > abilityDamage) {
                        abilityDamage = HelperMethods.commonSpellAttributeScaling(spellScalingModifier, (class_1297)this.sourceEntity, "fire");
                    }
                }
                livingEntity.method_5643(damageSource, (float)this.additionalData + (float)amplifier / 4.0f + abilityDamage);
                serverWorld.method_8396(null, livingEntity.method_24515(), soundEvent, livingEntity.method_5634(), volume, pitch);
                HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.method_19538(), (class_2394)class_2398.field_11239, 1.0, 4);
                HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.method_19538(), (class_2394)class_2398.field_22247, 1.0, 6);
                HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.method_19538(), (class_2394)class_2398.field_11251, 1.0, 6);
            }
        }
        super.method_5572(livingEntity, amplifier);
    }

    @Override
    public boolean method_5552(int pDuration, int pAmplifier) {
        return super.method_5552(pDuration, pAmplifier);
    }
}

