/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.client.renderers.LanternRendererExtension;
import net.mehvahdjukaar.amendments.common.block.WallLanternBlock;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.moonlight.api.item.IThirdPersonSpecialItemRenderer;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_773;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class WallLanternModelsManager {
    private static final Map<class_2248, class_2960> SPECIAL_MOUNT_TEXTURES = new IdentityHashMap<class_2248, class_2960>();
    private static final Map<class_2248, class_2960> SPECIAL_LANTERN_MODELS = new IdentityHashMap<class_2248, class_2960>();
    private static final Set<class_2248> POSSIBLE_LANTERNS = new HashSet<class_2248>();
    private static boolean initialized = false;
    private static boolean animAdded = false;

    public static void refreshModels(class_3300 manager) {
        WallLanternModelsManager.reloadTextures(manager);
        WallLanternModelsManager.reloadModels(manager);
    }

    private static void reloadModels(class_3300 manager) {
        if (!initialized) {
            WallLanternModelsManager.populate();
            initialized = true;
        }
        SPECIAL_LANTERN_MODELS.clear();
        for (class_2248 l : POSSIBLE_LANTERNS) {
            class_2960 reg = Utils.getID((class_2248)l);
            Object namespace = reg.method_12836().equals("minecraft") || reg.method_12836().equals("amendments") ? "" : reg.method_12836() + "/";
            String s = "block/custom_wall_lanterns/" + (String)namespace + reg.method_12832();
            class_2960 fullPath = Amendments.res("models/" + s + ".json");
            Optional resource = manager.method_14486(fullPath);
            if (!resource.isPresent()) continue;
            SPECIAL_LANTERN_MODELS.put(l, Amendments.res(s));
        }
    }

    private static void reloadTextures(class_3300 manager) {
        if (!initialized) {
            WallLanternModelsManager.populate();
            initialized = true;
        }
        SPECIAL_MOUNT_TEXTURES.clear();
        for (class_2248 l : POSSIBLE_LANTERNS) {
            class_2960 reg = Utils.getID((class_2248)l);
            Object namespace = reg.method_12836().equals("minecraft") || reg.method_12836().equals("amendments") ? "" : reg.method_12836() + "/";
            String s = "textures/block/wall_lanterns/" + (String)namespace + reg.method_12832() + ".json";
            class_2960 fullPath = Amendments.res(s);
            Optional resource = manager.method_14486(fullPath);
            if (!resource.isPresent()) continue;
            try {
                InputStream stream = ((class_3298)resource.get()).method_14482();
                try {
                    JsonObject bsElement = RPUtils.deserializeJson((InputStream)stream);
                    String texture = RPUtils.findFirstResourceInJsonRecursive((JsonElement)bsElement);
                    if (texture.isEmpty()) continue;
                    SPECIAL_MOUNT_TEXTURES.put(l, new class_2960(texture));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static void populate() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (class_2248 i : class_7923.field_41175) {
            if (!WallLanternBlock.isValidBlock(i)) continue;
            builder.add((Object)i);
        }
        POSSIBLE_LANTERNS.clear();
        POSSIBLE_LANTERNS.addAll((Collection<class_2248>)builder.build());
    }

    @Nullable
    public static class_1058 getTexture(class_2248 block) {
        class_2960 res = SPECIAL_MOUNT_TEXTURES.get(block);
        if (res == null) {
            return null;
        }
        return (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(res);
    }

    public static void registerSpecialModels(ClientHelper.SpecialModelEvent event) {
        SPECIAL_LANTERN_MODELS.values().forEach(arg_0 -> ((ClientHelper.SpecialModelEvent)event).register(arg_0));
    }

    public static class_1087 getModel(class_773 blockModelShaper, class_2680 lantern) {
        class_2960 special = SPECIAL_LANTERN_MODELS.get(lantern.method_26204());
        if (special != null) {
            return ClientHelper.getModel((class_1092)class_310.method_1551().method_1554(), (class_2960)special);
        }
        return blockModelShaper.method_3335(lantern);
    }

    public static Set<class_1792> getValidLanternItems() {
        return POSSIBLE_LANTERNS.stream().map(class_2248::method_8389).collect(Collectors.toSet());
    }

    public static void addAnimations() {
        if (initialized && !animAdded && ClientConfigs.LANTERN_HOLDING.get().booleanValue()) {
            animAdded = true;
            LanternRendererExtension anim = new LanternRendererExtension();
            POSSIBLE_LANTERNS.stream().map(class_2248::method_8389).collect(Collectors.toSet()).forEach(item -> IThirdPersonSpecialItemRenderer.attachToItem((class_1792)item, (IThirdPersonSpecialItemRenderer)anim));
        }
    }
}

