/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.network;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1840;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_3722;
import net.minecraft.class_5513;
import net.minecraft.class_5837;

public class SyncLecternBookMessage
implements Message {
    private final List<String> pages;
    private final Optional<String> title;
    private final class_2338 pos;

    public SyncLecternBookMessage(class_2338 pos, List<String> list, Optional<String> optional) {
        this.pos = pos;
        this.pages = ImmutableList.copyOf(list);
        this.title = optional;
    }

    public SyncLecternBookMessage(class_2540 friendlyByteBuf) {
        this.pos = friendlyByteBuf.method_10811();
        this.pages = (List)friendlyByteBuf.method_34068(class_2540.method_37453(Lists::newArrayListWithCapacity, (int)200), b -> b.method_10800(8192));
        this.title = friendlyByteBuf.method_37436(b -> b.method_10800(128));
    }

    public void writeToBuffer(class_2540 buffer) {
        buffer.method_10807(this.pos);
        buffer.method_34062(this.pages, (friendlyByteBuf, string) -> friendlyByteBuf.method_10788(string, 8192));
        buffer.method_37435(this.title, (friendlyByteBuf, string) -> friendlyByteBuf.method_10788(string, 128));
    }

    public void handle(ChannelHandler.Context context) {
        class_3722 be;
        class_1799 book;
        class_3222 player = (class_3222)context.getSender();
        class_1937 level = player.method_37908();
        class_2586 class_25862 = level.method_8321(this.pos);
        if (class_25862 instanceof class_3722 && (book = (be = (class_3722)class_25862).method_17520()).method_7909() instanceof class_1840) {
            ArrayList list = Lists.newArrayList();
            Objects.requireNonNull(list);
            this.title.ifPresent(list::add);
            Stream limit = this.pages.stream().limit(100L);
            Objects.requireNonNull(list);
            limit.forEach(list::add);
            Consumer<List> consumer = this.title.isPresent() ? l -> this.signBook(be, player, book, (class_5837)l.get(0), l.subList(1, l.size())) : l -> this.updateBookContents(be, player, book, (List<class_5837>)l);
            this.filterTextPacket(player, list, class_5513::method_31289).thenAcceptAsync(consumer, (Executor)level.method_8503());
        }
    }

    private <T, R> CompletableFuture<R> filterTextPacket(class_3222 player, T message, BiFunction<class_5513, T, CompletableFuture<R>> processor) {
        return processor.apply(player.method_31273(), (class_5513)message).thenApply(object -> {
            if (!player.field_13987.method_48106()) {
                throw new CancellationException("disconnected");
            }
            return object;
        });
    }

    private void updateBookContents(class_3722 be, class_3222 player, class_1799 itemstack, List<class_5837> pages) {
        this.updateBookPages(be, player, pages, UnaryOperator.identity(), itemstack);
    }

    private void signBook(class_3722 be, class_3222 player, class_1799 itemstack, class_5837 title, List<class_5837> pages) {
        class_1799 newStack = new class_1799((class_1935)class_1802.field_8360);
        class_2487 compoundtag = itemstack.method_7969();
        if (compoundtag != null) {
            newStack.method_7980(compoundtag.method_10553());
        }
        newStack.method_7959("author", (class_2520)class_2519.method_23256((String)player.method_5477().getString()));
        if (player.method_33793()) {
            newStack.method_7959("title", (class_2520)class_2519.method_23256((String)title.method_45061()));
        } else {
            newStack.method_7959("filtered_title", (class_2520)class_2519.method_23256((String)title.method_45061()));
            newStack.method_7959("title", (class_2520)class_2519.method_23256((String)title.comp_841()));
        }
        this.updateBookPages(be, player, pages, string -> class_2561.class_2562.method_10867((class_2561)class_2561.method_43470((String)string)), newStack);
    }

    private void updateBookPages(class_3722 be, class_3222 player, List<class_5837> pages, UnaryOperator<String> unaryOperator, class_1799 book) {
        class_2499 listtag = new class_2499();
        if (player.method_33793()) {
            Stream<class_2519> stringTagStream = pages.stream().map(arg -> class_2519.method_23256((String)((String)unaryOperator.apply(arg.method_45061()))));
            Objects.requireNonNull(listtag);
            stringTagStream.forEach(arg_0 -> listtag.add(arg_0));
        } else {
            class_2487 compoundtag = new class_2487();
            int j = pages.size();
            for (int i = 0; i < j; ++i) {
                class_5837 filteredtext = pages.get(i);
                String s = filteredtext.comp_841();
                listtag.add((Object)class_2519.method_23256((String)((String)unaryOperator.apply(s))));
                if (!filteredtext.method_45063()) continue;
                compoundtag.method_10582(String.valueOf(i), (String)unaryOperator.apply(filteredtext.method_45061()));
            }
            if (!compoundtag.method_33133()) {
                book.method_7959("filtered_pages", (class_2520)compoundtag);
            }
        }
        book.method_7959("pages", (class_2520)listtag);
        be.method_17513(book);
        player.method_37908().method_8413(this.pos, be.method_11010(), be.method_11010(), 3);
    }
}

