/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.quad.blender;

import me.jellysquid.mods.sodium.client.model.quad.ModelQuadColorProvider;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.blender.BiomeColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFlags;
import me.jellysquid.mods.sodium.client.util.color.ColorARGB;
import me.jellysquid.mods.sodium.client.util.color.ColorMixer;
import net.minecraft.class_1920;
import net.minecraft.class_2338;

public class SmoothBiomeColorBlender
implements BiomeColorBlender {
    private final int[] cachedRet = new int[4];
    private final class_2338.class_2339 mpos = new class_2338.class_2339();

    @Override
    public <T> int[] getColors(class_1920 world, class_2338 origin, ModelQuadView quad, ModelQuadColorProvider<T> colorizer, T state) {
        int[] colors = this.cachedRet;
        boolean aligned = ModelQuadFlags.contains(quad.getFlags(), 1);
        for (int i = 0; i < 4; ++i) {
            colors[i] = aligned ? this.getVertexColor(colorizer, world, state, origin, quad, i) : this.getInterpolatedVertexColor(colorizer, world, state, origin, quad, i);
        }
        return colors;
    }

    private <T> int getVertexColor(ModelQuadColorProvider<T> colorizer, class_1920 world, T state, class_2338 origin, ModelQuadView quad, int vertexIdx) {
        int x = origin.method_10263() + (int)quad.getX(vertexIdx);
        int z = origin.method_10260() + (int)quad.getZ(vertexIdx);
        int color = this.getBlockColor(colorizer, world, state, origin, x, z, quad.getColorIndex());
        return ColorARGB.toABGR(color);
    }

    private <T> int getBlockColor(ModelQuadColorProvider<T> colorizer, class_1920 world, T state, class_2338 origin, int x, int z, int colorIdx) {
        return colorizer.getColor(state, world, (class_2338)this.mpos.method_10103(x, origin.method_10264(), z), colorIdx);
    }

    private <T> int getInterpolatedVertexColor(ModelQuadColorProvider<T> colorizer, class_1920 world, T state, class_2338 origin, ModelQuadView quad, int vertexIdx) {
        int result;
        float x = quad.getX(vertexIdx);
        float z = quad.getZ(vertexIdx);
        int intX = (int)x;
        int intZ = (int)z;
        int originX = origin.method_10263() + intX;
        int originZ = origin.method_10260() + intZ;
        int c1 = this.getBlockColor(colorizer, world, state, origin, originX, originZ, quad.getColorIndex());
        int c2 = this.getBlockColor(colorizer, world, state, origin, originX, originZ + 1, quad.getColorIndex());
        int c3 = this.getBlockColor(colorizer, world, state, origin, originX + 1, originZ, quad.getColorIndex());
        int c4 = this.getBlockColor(colorizer, world, state, origin, originX + 1, originZ + 1, quad.getColorIndex());
        if (c1 == c2 && c2 == c3 && c3 == c4) {
            result = c1;
        } else {
            float fracX = x - (float)intX;
            float fracZ = z - (float)intZ;
            int z1 = ColorMixer.getStartRatio(fracZ);
            int z2 = ColorMixer.getEndRatio(fracZ);
            int r1 = ColorMixer.mixARGB(c1, c2, z1, z2);
            int r2 = ColorMixer.mixARGB(c3, c4, z1, z2);
            int x1 = ColorMixer.getStartRatio(fracX);
            int x2 = ColorMixer.getEndRatio(fracX);
            result = ColorMixer.mixARGB(r1, r2, x1, x2);
        }
        return ColorARGB.toABGR(result);
    }
}

